/***********************************************************************/
/*    Transducer Block 1: Modbus TB                                    */
/***********************************************************************/

BLOCK transducer_block_1
{
    TYPE      TRANSDUCER;
    NUMBER    1;
}

trans1_blk_reserve                          LIKE VARIABLE    phys_blk_reserve
{
}

VARIABLE trans1_blk_object
{
    LABEL       [blk_block_object];
    HELP        [blk_block_object_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    3,    [blk_block_object_TRANSDUCER]        }
    }
    HANDLING    READ;
}

VARIABLE trans1_blk_parent_class
{
    LABEL       [blk_parent_class];
    HELP        [trans_blk_parent_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    128,    "Microcyber Custom"   }
    }
    HANDLING    READ;
}

VARIABLE trans1_blk_class
{
    LABEL       [blk_class];
    HELP        [trans_blk_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        DEFAULT_VALUE    4;
        {    1,        "IF105 Converter"              },
        {    2,        "FI105 Converter"              },
        {    3,        "Modbus PA Converter"          },
        {    4,        "M0307 Modbus to PA Module"    },
        {    5,        "G0307 Modbus to PA Gateway"   }
    }
    HANDLING    READ;
}
trans1_blk_dd_reference                     LIKE VARIABLE    phys_blk_dd_reference
{
}

trans1_blk_dd_rev                           LIKE VARIABLE    phys_blk_dd_rev
{
}

trans1_blk_profile                          LIKE VARIABLE    phys_blk_profile
{
}

trans1_blk_profile_rev                      LIKE VARIABLE    phys_blk_profile_rev
{
}

trans1_blk_execution_time                   LIKE VARIABLE    phys_blk_execution_time
{
}

trans1_blk_num_parameters                   LIKE VARIABLE    phys_blk_num_parameters
{
}

trans1_blk_index_view_1                     LIKE VARIABLE    phys_blk_index_view_1
{
}

trans1_blk_num_view_lists                   LIKE VARIABLE    phys_blk_num_view_lists
{
}

trans1_st_rev                               LIKE VARIABLE    phys_st_rev
{
}

trans1_tag_desc                             LIKE VARIABLE    phys_tag_desc
{
    REDEFINE LABEL        [MC_trans_tag_desc];
}

trans1_strategy                             LIKE VARIABLE    phys_strategy
{
}

trans1_alert_key                            LIKE VARIABLE    phys_alert_key
{
}

trans1_target_mode                            LIKE VARIABLE    phys_target_mode
{
}

trans1_actual_mode                            LIKE VARIABLE    phys_actual_mode
{
}

trans1_permitted_mode                        LIKE VARIABLE    phys_permitted_mode
{
}

trans1_normal_mode                            LIKE VARIABLE    phys_normal_mode
{
}

trans1_current_state_alarm_sum                LIKE VARIABLE    phys_current_state_alarm_sum
{
}

trans1_unacknowledged_state_alarm_sum        LIKE VARIABLE    phys_unacknowledged_state_alarm_sum
{
}

trans1_unreported_state_alarm_sum            LIKE VARIABLE    phys_unreported_state_alarm_sum
{
}

trans1_disabled_state_alarm_sum                LIKE VARIABLE    phys_disabled_state_alarm_sum
{
}

/*---------------------------------------------------------------------*/
/*    Transducer Block Parameter                                       */
/*---------------------------------------------------------------------*/
VARIABLE    trans1_bad_status
{
    LABEL           "Bad Status" ;
    HELP            "Bad Status" ;
    CLASS           CONTAINED & DYNAMIC;
    TYPE            BIT_ENUMERATED (4)
    {
        { 0x01000000, "Mod_In1",    "Mod_In1 has bad status" },
        { 0x02000000, "Mod_In2",    "Mod_In2 has bad status" },
        { 0x04000000, "Mod_In3",    "Mod_In3 has bad status" },
        { 0x08000000, "Mod_In4",    "Mod_In4 has bad status" },
        /*
        { 0x10000000, "Mod_In5",    "Mod_In5 has bad status" },
        { 0x20000000, "Mod_In6",    "Mod_In6 has bad status" },
        { 0x40000000, "Mod_In7",    "Mod_In7 has bad status" },
        { 0x80000000, "Mod_In8",    "Mod_In8 has bad status" },
        */
        { 0x00010000, "Mod_Out1",    "Mod_Out1 has bad status" },
        { 0x00020000, "Mod_Out2",    "Mod_Out2 has bad status" },
        { 0x00040000, "Mod_Out3",    "Mod_Out3 has bad status" },
        { 0x00080000, "Mod_Out4",    "Mod_Out4 has bad status" },
        /*
        { 0x00100000, "Mod_Out5",    "Mod_Out5 has bad status" },
        { 0x00200000, "Mod_Out6",    "Mod_Out6 has bad status" },
        { 0x00400000, "Mod_Out7",    "Mod_Out7 has bad status" },
        { 0x00800000, "Mod_Out8",    "Mod_Out8 has bad status" },
        */
        { 0x00000100, "Mod_In_D1",    "Mod_In_D1 has bad status" },
        { 0x00000200, "Mod_In_D2",    "Mod_In_D2 has bad status" },
        { 0x00000400, "Mod_In_D3",    "Mod_In_D3 has bad status" },
        { 0x00000800, "Mod_In_D4",    "Mod_In_D4 has bad status" },
        /*
        { 0x00001000, "Mod_In_D5",    "Mod_In_D5 has bad status" },
        { 0x00002000, "Mod_In_D6",    "Mod_In_D6 has bad status" },
        { 0x00004000, "Mod_In_D7",    "Mod_In_D7 has bad status" },
        { 0x00008000, "Mod_In_D8",    "Mod_In_D8 has bad status" },
        */
        { 0x00000001, "Mod_Out_D1",    "Mod_Out_D1 has bad status" },
        { 0x00000002, "Mod_Out_D2",    "Mod_Out_D2 has bad status" },
        { 0x00000004, "Mod_Out_D3",    "Mod_Out_D3 has bad status" },
        { 0x00000008, "Mod_Out_D4",    "Mod_Out_D4 has bad status" },
        /*
        { 0x00000010, "Mod_Out_D5",    "Mod_Out_D5 has bad status" },
        { 0x00000020, "Mod_Out_D6",    "Mod_Out_D6 has bad status" },
        { 0x00000040, "Mod_Out_D7",    "Mod_Out_D7 has bad status" },
        { 0x00000080, "Mod_Out_D8",    "Mod_Out_D8 has bad status" }
        */
    }
    HANDLING        READ;
    STYLE      "MULTILINE 10 16" ;
}

VARIABLE    trans1_err_look_result_in1
{
    LABEL           "Mod_In1 Err Look Result" ;
    HELP            "Mod_In1 Err Look Result" ;
    CLASS           CONTAINED & DYNAMIC;
    TYPE            ENUMERATED (1)
    {
        { 0x00, "Ok"                                           ,    "Ok"                                                     },
        { 0x01, "0x01:Illegal Function"                        ,    "Illegal Function"                                       },
        { 0x02, "0x02:Illegal Data Address"                    ,    "Illegal Data Address"                                   },
        { 0x03, "0x03:Illegal Data Value"                      ,    "Illegal Data Value"                                     },
        { 0x04, "0x04:Slave Device Failure"                    ,    "Slave Device Failure"                                   },
        { 0x05, "Unknown Exception Code"                       ,    "Unknown Exception Code"                                 },
        { 0xFC, "0xFC:No Communication"                        ,    "No Communication"                                       },
        { 0xFD, "0xFD:Data Type Mismatch"                      ,    "Data Type selected cannot be used by this variable"     },
        { 0xFE, "0xFE:Function Code Mismatch"                  ,    "Function Code selected cannot be used by this variable" },
        { 0xFF, "0xFF:Comm Failure"                            ,    "Communication Failure on Modbus"                        }
    }
    HANDLING        READ;
}

trans1_err_look_result_in2                LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "Mod_In2 Err Look Result";
    REDEFINE HELP        "Mod_In2 Err Look Result" ;
}

trans1_err_look_result_in3                LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "Mod_In3 Err Look Result";
    REDEFINE HELP        "Mod_In3 Err Look Result" ;
}

trans1_err_look_result_in4                LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "Mod_In4 Err Look Result";
    REDEFINE HELP        "Mod_In4 Err Look Result" ;
}

trans1_err_look_result_out1                LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "Mod_Out1 Err Look Result";
    REDEFINE HELP        "Mod_Out1 Err Look Result" ;
}

trans1_err_look_result_out2                LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "Mod_Out2 Err Look Result";
    REDEFINE HELP        "Mod_Out2 Err Look Result" ;
}

trans1_err_look_result_out3                LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "Mod_Out3 Err Look Result";
    REDEFINE HELP        "Mod_Out3 Err Look Result" ;
}

trans1_err_look_result_out4                LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "Mod_Out4 Err Look Result";
    REDEFINE HELP        "Mod_Out4 Err Look Result" ;
}

trans1_err_look_result_in_d1                LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "Mod_In_d1 Err Look Result";
    REDEFINE HELP        "Mod_In_d1 Err Look Result" ;
}

trans1_err_look_result_in_d2                LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "Mod_In_d2 Err Look Result";
    REDEFINE HELP        "Mod_In_d2 Err Look Result" ;
}

trans1_err_look_result_in_d3                LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "Mod_In_d3 Err Look Result";
    REDEFINE HELP        "Mod_In_d3 Err Look Result" ;
}

trans1_err_look_result_in_d4                LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "Mod_In_d4 Err Look Result";
    REDEFINE HELP        "Mod_In_d4 Err Look Result" ;
}

trans1_err_look_result_out_d1                LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "Mod_Out_d1 Err Look Result";
    REDEFINE HELP        "Mod_Out_d1 Err Look Result" ;
}

trans1_err_look_result_out_d2                LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "Mod_Out_d2 Err Look Result";
    REDEFINE HELP        "Mod_Out_d2 Err Look Result" ;
}

trans1_err_look_result_out_d3                LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "Mod_Out_d3 Err Look Result";
    REDEFINE HELP        "Mod_Out_d3 Err Look Result" ;
}

trans1_err_look_result_out_d4                LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "Mod_Out_d4 Err Look Result";
    REDEFINE HELP        "Mod_Out_d4 Err Look Result" ;
}

VARIABLE trans1_mod_in1_value
{
    LABEL       "Mod_In1" ;
    HELP        "Modbus Analog Input 1";
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT;
    HANDLING    READ;
}

VARIABLE trans1_mod_in1_status_quality
{
    LABEL       [status_quality];
    HELP        [value_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING    READ;
}

trans1_mod_in1_status_limit            LIKE VARIABLE    trans1_mod_in1_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE trans1_mod_in2_value
{
    LABEL       "Mod_In2" ;
    HELP        "Modbus Analog Input 2";
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT;
    HANDLING    READ;
}

VARIABLE trans1_mod_in2_status_quality
{
    LABEL       [status_quality];
    HELP        [value_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING    READ;
}

trans1_mod_in2_status_limit            LIKE VARIABLE    trans1_mod_in2_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE trans1_mod_in3_value
{
    LABEL       "Mod_In3" ;
    HELP        "Modbus Analog Input 3";
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT;
    HANDLING    READ;
}

VARIABLE trans1_mod_in3_status_quality
{
    LABEL       [status_quality];
    HELP        [value_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING    READ;
}

trans1_mod_in3_status_limit            LIKE VARIABLE    trans1_mod_in3_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE trans1_mod_in4_value
{
    LABEL       "Mod_In4" ;
    HELP        "Modbus Analog Input 2";
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT;
    HANDLING    READ;
}

VARIABLE trans1_mod_in4_status_quality
{
    LABEL       [status_quality];
    HELP        [value_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING    READ;
}

trans1_mod_in4_status_limit            LIKE VARIABLE    trans1_mod_in4_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE trans1_mod_out1_value
{
    LABEL       "Mod_Out1" ;
    HELP        "Modbus Analog Output 1";
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT;
    HANDLING    READ;
}

VARIABLE trans1_mod_out1_status_quality
{
    LABEL       [status_quality];
    HELP        [value_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING    READ;
}

trans1_mod_out1_status_limit            LIKE VARIABLE    trans1_mod_out1_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE trans1_mod_out2_value
{
    LABEL       "Mod_Out2" ;
    HELP        "Modbus Analog Output 2";
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT;
    HANDLING    READ;
}

VARIABLE trans1_mod_out2_status_quality
{
    LABEL       [status_quality];
    HELP        [value_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING    READ;
}

trans1_mod_out2_status_limit            LIKE VARIABLE    trans1_mod_out1_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE trans1_mod_out3_value
{
    LABEL       "Mod_Out3" ;
    HELP        "Modbus Analog Output 3";
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT;
    HANDLING    READ;
}

VARIABLE trans1_mod_out3_status_quality
{
    LABEL       [status_quality];
    HELP        [value_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING    READ;
}

trans1_mod_out3_status_limit            LIKE VARIABLE    trans1_mod_out1_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE trans1_mod_out4_value
{
    LABEL       "Mod_Out4" ;
    HELP        "Modbus Analog Output 4";
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT;
    HANDLING    READ;
}

VARIABLE trans1_mod_out4_status_quality
{
    LABEL       [status_quality];
    HELP        [value_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING    READ;
}

trans1_mod_out4_status_limit            LIKE VARIABLE    trans1_mod_out4_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE trans1_mod_in_d1_value
{
    LABEL       "Mod_In_D1" ;
    HELP        "Modbus Discrete Input 1";
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1) ;
    HANDLING    READ;
}

VARIABLE trans1_mod_in_d1_status_quality
{
    LABEL       [status_quality];
    HELP        [value_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING    READ;
}

trans1_mod_in_d1_status_limit            LIKE VARIABLE    trans1_mod_in_d1_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE trans1_mod_in_d2_value
{
    LABEL       "Mod_In_D2" ;
    HELP        "Modbus Discrete Input 2";
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1) ;
    HANDLING    READ;
}

VARIABLE trans1_mod_in_d2_status_quality
{
    LABEL       [status_quality];
    HELP        [value_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING    READ;
}

trans1_mod_in_d2_status_limit            LIKE VARIABLE    trans1_mod_in_d1_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE trans1_mod_in_d3_value
{
    LABEL       "Mod_In_D3" ;
    HELP        "Modbus Discrete Input 3";
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1) ;
    HANDLING    READ;
}

VARIABLE trans1_mod_in_d3_status_quality
{
    LABEL       [status_quality];
    HELP        [value_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING    READ;
}

trans1_mod_in_d3_status_limit            LIKE VARIABLE    trans1_mod_in_d3_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE trans1_mod_in_d4_value
{
    LABEL       "Mod_In_D4" ;
    HELP        "Modbus Discrete Input 4";
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1) ;
    HANDLING    READ;
}

VARIABLE trans1_mod_in_d4_status_quality
{
    LABEL       [status_quality];
    HELP        [value_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING    READ;
}

trans1_mod_in_d4_status_limit            LIKE VARIABLE    trans1_mod_in_d4_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE trans1_mod_out_d1_value
{
    LABEL       "Mod_Out_D1" ;
    HELP        "Modbus Discrete Output 1";
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1) ;
    HANDLING    READ;
}

VARIABLE trans1_mod_out_d1_status_quality
{
    LABEL       [status_quality];
    HELP        [value_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING    READ;
}

trans1_mod_out_d1_status_limit            LIKE VARIABLE    trans1_mod_out_d1_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE trans1_mod_out_d2_value
{
    LABEL       "Mod_Out_D2" ;
    HELP        "Modbus Discrete Output 2";
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1) ;
    HANDLING    READ;
}

VARIABLE trans1_mod_out_d2_status_quality
{
    LABEL       [status_quality];
    HELP        [value_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING    READ;
}

trans1_mod_out_d2_status_limit            LIKE VARIABLE    trans1_mod_out_d1_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE trans1_mod_out_d3_value
{
    LABEL       "Mod_Out_D3" ;
    HELP        "Modbus Discrete Output 3";
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1) ;
    HANDLING    READ;
}

VARIABLE trans1_mod_out_d3_status_quality
{
    LABEL       [status_quality];
    HELP        [value_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING    READ;
}

trans1_mod_out_d3_status_limit            LIKE VARIABLE    trans1_mod_out_d3_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE trans1_mod_out_d4_value
{
    LABEL       "Mod_Out_D4" ;
    HELP        "Modbus Discrete Output 4";
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1) ;
    HANDLING    READ;
}

VARIABLE trans1_mod_out_d4_status_quality
{
    LABEL       [status_quality];
    HELP        [value_status_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING    READ;
}

trans1_mod_out_d4_status_limit            LIKE VARIABLE    trans1_mod_out_d4_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE trans1_generic_float_1
{
    LABEL       [generic_float_1];
    HELP        [generic_float_1_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
        {
                DEFAULT_VALUE        0.0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_float_2
{
    LABEL       [generic_float_2];
    HELP        [generic_float_2_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
        {
                DEFAULT_VALUE        0.0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_float_3
{
    LABEL       [generic_float_3];
    HELP        [generic_float_3_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
        {
                DEFAULT_VALUE        0.0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_float_4
{
    LABEL       [generic_float_4];
    HELP        [generic_float_4_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
        {
                DEFAULT_VALUE        0.0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_float_5
{
    LABEL       [generic_float_5];
    HELP        [generic_float_5_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
        {
                DEFAULT_VALUE        0.0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_float_6
{
    LABEL       [generic_float_6];
    HELP        [generic_float_6_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
        {
                DEFAULT_VALUE        0.0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_float_7
{
    LABEL       [generic_float_7];
    HELP        [generic_float_7_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
        {
                DEFAULT_VALUE        0.0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_float_8
{
    LABEL       [generic_float_8];
    HELP        [generic_float_8_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
        {
                DEFAULT_VALUE        0.0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_float_9
{
    LABEL       [generic_float_9];
    HELP        [generic_float_9_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
        {
                DEFAULT_VALUE        0.0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_float_10
{
    LABEL       [generic_float_10];
    HELP        [generic_float_10_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
        {
                DEFAULT_VALUE        0.0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign32_1
{
    LABEL       [generic_usign32_1];
    HELP        [generic_usign32_1_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign32_2
{
    LABEL       [generic_usign32_2];
    HELP        [generic_usign32_2_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign32_3
{
    LABEL       [generic_usign32_3];
    HELP        [generic_usign32_3_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign32_4
{
    LABEL       [generic_usign32_4];
    HELP        [generic_usign32_4_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign32_5
{
    LABEL       [generic_usign32_5];
    HELP        [generic_usign32_5_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign32_6
{
    LABEL       [generic_usign32_6];
    HELP        [generic_usign32_6_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign32_7
{
    LABEL       [generic_usign32_7];
    HELP        [generic_usign32_7_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign32_8
{
    LABEL       [generic_usign32_8];
    HELP        [generic_usign32_8_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign32_9
{
    LABEL       [generic_usign32_9];
    HELP        [generic_usign32_9_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign32_10
{
    LABEL       [generic_usign32_10];
    HELP        [generic_usign32_10_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign16_1
{
    LABEL       [generic_usign16_1];
    HELP        [generic_usign16_1_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign16_2
{
    LABEL       [generic_usign16_2];
    HELP        [generic_usign16_2_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign16_3
{
    LABEL       [generic_usign16_3];
    HELP        [generic_usign16_3_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign16_4
{
    LABEL       [generic_usign16_4];
    HELP        [generic_usign16_4_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign16_5
{
    LABEL       [generic_usign16_5];
    HELP        [generic_usign16_5_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign16_6
{
    LABEL       [generic_usign16_6];
    HELP        [generic_usign16_6_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign16_7
{
    LABEL       [generic_usign16_7];
    HELP        [generic_usign16_7_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign16_8
{
    LABEL       [generic_usign16_8];
    HELP        [generic_usign16_8_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign16_9
{
    LABEL       [generic_usign16_9];
    HELP        [generic_usign16_9_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign16_10
{
    LABEL       [generic_usign16_10];
    HELP        [generic_usign16_10_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign8_1
{
    LABEL       [generic_usign8_1];
    HELP        [generic_usign8_1_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign8_2
{
    LABEL       [generic_usign8_2];
    HELP        [generic_usign8_2_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign8_3
{
    LABEL       [generic_usign8_3];
    HELP        [generic_usign8_3_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign8_4
{
    LABEL       [generic_usign8_4];
    HELP        [generic_usign8_4_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign8_5
{
    LABEL       [generic_usign8_5];
    HELP        [generic_usign8_5_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign8_6
{
    LABEL       [generic_usign8_6];
    HELP        [generic_usign8_6_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign8_7
{
    LABEL       [generic_usign8_7];
    HELP        [generic_usign8_7_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign8_8
{
    LABEL       [generic_usign8_8];
    HELP        [generic_usign8_8_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign8_9
{
    LABEL       [generic_usign8_9];
    HELP        [generic_usign8_9_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_usign8_10
{
    LABEL       [generic_usign8_10];
    HELP        [generic_usign8_10_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (1)
        {
                DEFAULT_VALUE        0;
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_Octet_1
{
    LABEL       [generic_Octet_1];
    HELP        [generic_Octet_1_help];
    CLASS       CONTAINED;
    TYPE        ASCII (32)
        {
                DEFAULT_VALUE        " ";
        }
    HANDLING    READ & WRITE;
}

VARIABLE trans1_generic_Octet_2
{
    LABEL       [generic_Octet_2];
    HELP        [generic_Octet_2_help];
    CLASS       CONTAINED;
    TYPE        ASCII (32)
        {
                DEFAULT_VALUE        " ";
        }
    HANDLING    READ & WRITE;
}

trans1_err_info_float_1               LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_float_2               LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_float_3               LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_float_4               LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_float_5               LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_float_6               LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_float_7               LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_float_8               LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_float_9               LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_float_10              LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign32_1             LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign32_2             LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign32_3             LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign32_4             LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign32_5             LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign32_6             LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign32_7             LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign32_8             LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign32_9             LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign32_10            LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign16_1             LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign16_2             LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign16_3             LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign16_4             LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign16_5             LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign16_6             LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign16_7             LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign16_8             LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign16_9             LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign16_10            LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign8_1              LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign8_2              LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign8_3              LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign8_4              LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign8_5              LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign8_6              LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign8_7              LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign8_8              LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign8_9              LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_usign8_10             LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_octet_1               LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

trans1_err_info_octet_2               LIKE VARIABLE    trans1_err_look_result_in1
{
    REDEFINE LABEL       "";
    REDEFINE HELP        "" ;
}

/*---------------------------------------------------------------------*/
/*    Commands                                                         */
/*---------------------------------------------------------------------*/

COMMAND read_trans1_blk
{
    BLOCK transducer_block_1;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_blk_reserve,
            trans1_blk_object,
            trans1_blk_parent_class,
            trans1_blk_class,
            trans1_blk_dd_reference,
            trans1_blk_dd_rev,
            trans1_blk_profile,
            trans1_blk_profile_rev,
            trans1_blk_execution_time,
            trans1_blk_num_parameters,
            trans1_blk_index_view_1,
            trans1_blk_num_view_lists
        }
    }
}

COMMAND read_trans1_st_rev
{
    BLOCK transducer_block_1;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_st_rev
        }
    }
}

COMMAND read_trans1_tag_desc
{
    BLOCK transducer_block_1;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_tag_desc
        }
    }
}

COMMAND write_trans1_tag_desc
{
    BLOCK transducer_block_1;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_tag_desc
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_strategy
{
    BLOCK transducer_block_1;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_strategy
        }
    }
}

COMMAND write_trans1_strategy
{
    BLOCK transducer_block_1;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_strategy
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_alert_key
{
    BLOCK transducer_block_1;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_alert_key
        }
    }
}

COMMAND write_trans1_alert_key
{
    BLOCK transducer_block_1;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_alert_key
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_target_mode
{
    BLOCK transducer_block_1;
    INDEX 5;
    OPERATION  READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_target_mode
        }
    }
}

COMMAND write_trans1_target_mode
{
    BLOCK transducer_block_1;
    INDEX 5;
    OPERATION  WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_target_mode
        }
        REPLY
        {
        }
    }
}


COMMAND read_trans1_mode
{
    BLOCK transducer_block_1;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_actual_mode,
            trans1_permitted_mode,
            trans1_normal_mode
        }
    }
}

COMMAND read_trans1_alarm
{
    BLOCK transducer_block_1;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_current_state_alarm_sum,
            trans1_unacknowledged_state_alarm_sum,
            trans1_unreported_state_alarm_sum,
            trans1_disabled_state_alarm_sum
        }
    }
}

COMMAND read_trans1_bad_status
{
    BLOCK transducer_block_1;
    INDEX 12;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_bad_status
        }
    }
}

COMMAND read_trans1_err_look_result
{
    BLOCK transducer_block_1;
    INDEX 13;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_err_look_result_in1,
            trans1_err_look_result_in2,
            trans1_err_look_result_in3,
            trans1_err_look_result_in4,
            trans1_err_look_result_out1,
            trans1_err_look_result_out2,
            trans1_err_look_result_out3,
            trans1_err_look_result_out4,
            trans1_err_look_result_in_d1,
            trans1_err_look_result_in_d2,
            trans1_err_look_result_in_d3,
            trans1_err_look_result_in_d4,
            trans1_err_look_result_out_d1,
            trans1_err_look_result_out_d2,
            trans1_err_look_result_out_d3,
            trans1_err_look_result_out_d4
        }
    }
}

COMMAND read_trans1_mod_in1
{
    BLOCK transducer_block_1;
    INDEX 14;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_mod_in1_value,
            trans1_mod_in1_status_quality <0xFC>,
            trans1_mod_in1_status_limit   <0x03>
        }
    }
}

COMMAND read_trans1_mod_in2
{
    BLOCK transducer_block_1;
    INDEX 15;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_mod_in2_value,
            trans1_mod_in2_status_quality <0xFC>,
            trans1_mod_in2_status_limit   <0x03>
        }
    }
}

COMMAND read_trans1_mod_in3
{
    BLOCK transducer_block_1;
    INDEX 16;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_mod_in3_value,
            trans1_mod_in3_status_quality <0xFC>,
            trans1_mod_in3_status_limit   <0x03>
        }
    }
}

COMMAND read_trans1_mod_in4
{
    BLOCK transducer_block_1;
    INDEX 17;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_mod_in4_value,
            trans1_mod_in4_status_quality <0xFC>,
            trans1_mod_in4_status_limit   <0x03>
        }
    }
}

COMMAND read_trans1_mod_out1
{
    BLOCK transducer_block_1;
    INDEX 22;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_mod_out1_value,
            trans1_mod_out1_status_quality <0xFC>,
            trans1_mod_out1_status_limit   <0x03>
        }
    }
}

COMMAND read_trans1_mod_out2
{
    BLOCK transducer_block_1;
    INDEX 23;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_mod_out2_value,
            trans1_mod_out2_status_quality <0xFC>,
            trans1_mod_out2_status_limit   <0x03>
        }
    }
}

COMMAND read_trans1_mod_out3
{
    BLOCK transducer_block_1;
    INDEX 24;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_mod_out3_value,
            trans1_mod_out3_status_quality <0xFC>,
            trans1_mod_out3_status_limit   <0x03>
        }
    }
}

COMMAND read_trans1_mod_out4
{
    BLOCK transducer_block_1;
    INDEX 25;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_mod_out4_value,
            trans1_mod_out4_status_quality <0xFC>,
            trans1_mod_out4_status_limit   <0x03>
        }
    }
}

COMMAND read_trans1_mod_in_d1
{
    BLOCK transducer_block_1;
    INDEX 30;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_mod_in_d1_value,
            trans1_mod_in_d1_status_quality <0xFC>,
            trans1_mod_in_d1_status_limit   <0x03>
        }
    }
}

COMMAND read_trans1_mod_in_d2
{
    BLOCK transducer_block_1;
    INDEX 31;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_mod_in_d2_value,
            trans1_mod_in_d2_status_quality <0xFC>,
            trans1_mod_in_d2_status_limit   <0x03>
        }
    }
}

COMMAND read_trans1_mod_in_d3
{
    BLOCK transducer_block_1;
    INDEX 32;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_mod_in_d3_value,
            trans1_mod_in_d3_status_quality <0xFC>,
            trans1_mod_in_d3_status_limit   <0x03>
        }
    }
}

COMMAND read_trans1_mod_in_d4
{
    BLOCK transducer_block_1;
    INDEX 33;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_mod_in_d4_value,
            trans1_mod_in_d4_status_quality <0xFC>,
            trans1_mod_in_d4_status_limit   <0x03>
        }
    }
}

COMMAND read_trans1_mod_out_d1
{
    BLOCK transducer_block_1;
    INDEX 38;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_mod_out_d1_value,
            trans1_mod_out_d1_status_quality <0xFC>,
            trans1_mod_out_d1_status_limit   <0x03>
        }
    }
}

COMMAND read_trans1_mod_out_d2
{
    BLOCK transducer_block_1;
    INDEX 39;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_mod_out_d2_value,
            trans1_mod_out_d2_status_quality <0xFC>,
            trans1_mod_out_d2_status_limit   <0x03>
        }
    }
}

COMMAND read_trans1_mod_out_d3
{
    BLOCK transducer_block_1;
    INDEX 40;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_mod_out_d3_value,
            trans1_mod_out_d3_status_quality <0xFC>,
            trans1_mod_out_d3_status_limit   <0x03>
        }
    }
}

COMMAND read_trans1_mod_out_d4
{
    BLOCK transducer_block_1;
    INDEX 41;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_mod_out_d4_value,
            trans1_mod_out_d4_status_quality <0xFC>,
            trans1_mod_out_d4_status_limit   <0x03>
        }
    }
}

COMMAND read_trans1_generic_float_1
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_float_1
        }
    }
}

COMMAND write_trans1_generic_float_1
{
    BLOCK transducer_block_1;
    INDEX 46;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_float_1
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_float_2
{
    BLOCK transducer_block_1;
    INDEX 47;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_float_2
        }
    }
}

COMMAND write_trans1_generic_float_2
{
    BLOCK transducer_block_1;
    INDEX 47;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_float_2
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_float_3
{
    BLOCK transducer_block_1;
    INDEX 48;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_float_3
        }
    }
}

COMMAND write_trans1_generic_float_3
{
    BLOCK transducer_block_1;
    INDEX 48;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_float_3
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_float_4
{
    BLOCK transducer_block_1;
    INDEX 49;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_float_4
        }
    }
}

COMMAND write_trans1_generic_float_4
{
    BLOCK transducer_block_1;
    INDEX 49;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_float_4
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_generic_float_5
{
    BLOCK transducer_block_1;
    INDEX 50;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_float_5
        }
    }
}

COMMAND write_trans1_generic_float_5
{
    BLOCK transducer_block_1;
    INDEX 50;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_float_5
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_float_6
{
    BLOCK transducer_block_1;
    INDEX 51;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_float_6
        }
    }
}

COMMAND write_trans1_generic_float_6
{
    BLOCK transducer_block_1;
    INDEX 51;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_float_6
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_float_7
{
    BLOCK transducer_block_1;
    INDEX 52;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_float_7
        }
    }
}

COMMAND write_trans1_generic_float_7
{
    BLOCK transducer_block_1;
    INDEX 52;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_float_7
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_float_8
{
    BLOCK transducer_block_1;
    INDEX 53;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_float_8
        }
    }
}

COMMAND write_trans1_generic_float_8
{
    BLOCK transducer_block_1;
    INDEX 53;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_float_8
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_float_9
{
    BLOCK transducer_block_1;
    INDEX 54;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_float_9
        }
    }
}

COMMAND write_trans1_generic_float_9
{
    BLOCK transducer_block_1;
    INDEX 54;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_float_9
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_float_10
{
    BLOCK transducer_block_1;
    INDEX 55;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_float_10
        }
    }
}

COMMAND write_trans1_generic_float_10
{
    BLOCK transducer_block_1;
    INDEX 55;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_float_10
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign32_1
{
    BLOCK transducer_block_1;
    INDEX 56;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign32_1
        }
    }
}

COMMAND write_trans1_generic_usign32_1
{
    BLOCK transducer_block_1;
    INDEX 56;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign32_1
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign32_2
{
    BLOCK transducer_block_1;
    INDEX 57;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign32_2
        }
    }
}

COMMAND write_trans1_generic_usign32_2
{
    BLOCK transducer_block_1;
    INDEX 57;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign32_2
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign32_3
{
    BLOCK transducer_block_1;
    INDEX 58;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign32_3
        }
    }
}

COMMAND write_trans1_generic_usign32_3
{
    BLOCK transducer_block_1;
    INDEX 58;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign32_3
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_generic_usign32_4
{
    BLOCK transducer_block_1;
    INDEX 59;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign32_4
        }
    }
}

COMMAND write_trans1_generic_usign32_4
{
    BLOCK transducer_block_1;
    INDEX 59;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign32_4
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign32_5
{
    BLOCK transducer_block_1;
    INDEX 60;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign32_5
        }
    }
}

COMMAND write_trans1_generic_usign32_5
{
    BLOCK transducer_block_1;
    INDEX 60;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign32_5
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign32_6
{
    BLOCK transducer_block_1;
    INDEX 61;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign32_6
        }
    }
}

COMMAND write_trans1_generic_usign32_6
{
    BLOCK transducer_block_1;
    INDEX 61;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign32_6
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign32_7
{
    BLOCK transducer_block_1;
    INDEX 62;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign32_7
        }
    }
}

COMMAND write_trans1_generic_usign32_7
{
    BLOCK transducer_block_1;
    INDEX 62;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign32_7
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign32_8
{
    BLOCK transducer_block_1;
    INDEX 63;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign32_8
        }
    }
}

COMMAND write_trans1_generic_usign32_8
{
    BLOCK transducer_block_1;
    INDEX 63;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign32_8
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign32_9
{
    BLOCK transducer_block_1;
    INDEX 64;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign32_9
        }
    }
}

COMMAND write_trans1_generic_usign32_9
{
    BLOCK transducer_block_1;
    INDEX 64;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign32_9
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign32_10
{
    BLOCK transducer_block_1;
    INDEX 65;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign32_10
        }
    }
}

COMMAND write_trans1_generic_usign32_10
{
    BLOCK transducer_block_1;
    INDEX 65;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign32_10
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign16_1
{
    BLOCK transducer_block_1;
    INDEX 66;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign16_1
        }
    }
}

COMMAND write_trans1_generic_usign16_1
{
    BLOCK transducer_block_1;
    INDEX 66;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign16_1
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign16_2
{
    BLOCK transducer_block_1;
    INDEX 67;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign16_2
        }
    }
}

COMMAND write_trans1_generic_usign16_2
{
    BLOCK transducer_block_1;
    INDEX 67;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign16_2
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign16_3
{
    BLOCK transducer_block_1;
    INDEX 68;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign16_3
        }
    }
}

COMMAND write_trans1_generic_usign16_3
{
    BLOCK transducer_block_1;
    INDEX 68;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign16_3
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_generic_usign16_4
{
    BLOCK transducer_block_1;
    INDEX 69;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign16_4
        }
    }
}

COMMAND write_trans1_generic_usign16_4
{
    BLOCK transducer_block_1;
    INDEX 69;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign16_4
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign16_5
{
    BLOCK transducer_block_1;
    INDEX 70;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign16_5
        }
    }
}

COMMAND write_trans1_generic_usign16_5
{
    BLOCK transducer_block_1;
    INDEX 70;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign16_5
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign16_6
{
    BLOCK transducer_block_1;
    INDEX 71;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign16_6
        }
    }
}

COMMAND write_trans1_generic_usign16_6
{
    BLOCK transducer_block_1;
    INDEX 71;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign16_6
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign16_7
{
    BLOCK transducer_block_1;
    INDEX 72;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign16_7
        }
    }
}

COMMAND write_trans1_generic_usign16_7
{
    BLOCK transducer_block_1;
    INDEX 72;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign16_7
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign16_8
{
    BLOCK transducer_block_1;
    INDEX 73;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign16_8
        }
    }
}

COMMAND write_trans1_generic_usign16_8
{
    BLOCK transducer_block_1;
    INDEX 73;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign16_8
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign16_9
{
    BLOCK transducer_block_1;
    INDEX 74;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign16_9
        }
    }
}

COMMAND write_trans1_generic_usign16_9
{
    BLOCK transducer_block_1;
    INDEX 74;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign16_9
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign16_10
{
    BLOCK transducer_block_1;
    INDEX 75;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign16_10
        }
    }
}

COMMAND write_trans1_generic_usign16_10
{
    BLOCK transducer_block_1;
    INDEX 75;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign16_10
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign8_1
{
    BLOCK transducer_block_1;
    INDEX 76;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign8_1
        }
    }
}

COMMAND write_trans1_generic_usign8_1
{
    BLOCK transducer_block_1;
    INDEX 76;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign8_1
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign8_2
{
    BLOCK transducer_block_1;
    INDEX 77;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign8_2
        }
    }
}

COMMAND write_trans1_generic_usign8_2
{
    BLOCK transducer_block_1;
    INDEX 77;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign8_2
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign8_3
{
    BLOCK transducer_block_1;
    INDEX 78;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign8_3
        }
    }
}

COMMAND write_trans1_generic_usign8_3
{
    BLOCK transducer_block_1;
    INDEX 78;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign8_3
        }
        REPLY
        {
        }
    }
}
COMMAND read_trans1_generic_usign8_4
{
    BLOCK transducer_block_1;
    INDEX 79;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign8_4
        }
    }
}

COMMAND write_trans1_generic_usign8_4
{
    BLOCK transducer_block_1;
    INDEX 79;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign8_4
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign8_5
{
    BLOCK transducer_block_1;
    INDEX 80;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign8_5
        }
    }
}

COMMAND write_trans1_generic_usign8_5
{
    BLOCK transducer_block_1;
    INDEX 80;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign8_5
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign8_6
{
    BLOCK transducer_block_1;
    INDEX 81;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign8_6
        }
    }
}

COMMAND write_trans1_generic_usign8_6
{
    BLOCK transducer_block_1;
    INDEX 81;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign8_6
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign8_7
{
    BLOCK transducer_block_1;
    INDEX 82;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign8_7
        }
    }
}

COMMAND write_trans1_generic_usign8_7
{
    BLOCK transducer_block_1;
    INDEX 82;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign8_7
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign8_8
{
    BLOCK transducer_block_1;
    INDEX 83;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign8_8
        }
    }
}

COMMAND write_trans1_generic_usign8_8
{
    BLOCK transducer_block_1;
    INDEX 83;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign8_8
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign8_9
{
    BLOCK transducer_block_1;
    INDEX 84;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign8_9
        }
    }
}

COMMAND write_trans1_generic_usign8_9
{
    BLOCK transducer_block_1;
    INDEX 84;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign8_9
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_usign8_10
{
    BLOCK transducer_block_1;
    INDEX 85;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_usign8_10
        }
    }
}

COMMAND write_trans1_generic_usign8_10
{
    BLOCK transducer_block_1;
    INDEX 85;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_usign8_10
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_Octet_1
{
    BLOCK transducer_block_1;
    INDEX 86;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_Octet_1
        }
    }
}

COMMAND write_trans1_generic_Octet_1
{
    BLOCK transducer_block_1;
    INDEX 86;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_Octet_1
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_generic_Octet_2
{
    BLOCK transducer_block_1;
    INDEX 87;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_generic_Octet_2
        }
    }
}

COMMAND write_trans1_generic_Octet_2
{
    BLOCK transducer_block_1;
    INDEX 87;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans1_generic_Octet_2
        }
        REPLY
        {
        }
    }
}

COMMAND read_trans1_err_info_float
{
    BLOCK transducer_block_1;
    INDEX 88;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_err_info_float_1,
            trans1_err_info_float_2,
            trans1_err_info_float_3,
            trans1_err_info_float_4,
            trans1_err_info_float_5,
            trans1_err_info_float_6,
            trans1_err_info_float_7,
            trans1_err_info_float_8,
            trans1_err_info_float_9,
            trans1_err_info_float_10
        }
    }
}

COMMAND read_trans1_err_info_usign32
{
    BLOCK transducer_block_1;
    INDEX 89;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_err_info_usign32_1,
            trans1_err_info_usign32_2,
            trans1_err_info_usign32_3,
            trans1_err_info_usign32_4,
            trans1_err_info_usign32_5,
            trans1_err_info_usign32_6,
            trans1_err_info_usign32_7,
            trans1_err_info_usign32_8,
            trans1_err_info_usign32_9,
            trans1_err_info_usign32_10
        }
    }
}

COMMAND read_trans1_err_info_usign16
{
    BLOCK transducer_block_1;
    INDEX 90;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_err_info_usign16_1,
            trans1_err_info_usign16_2,
            trans1_err_info_usign16_3,
            trans1_err_info_usign16_4,
            trans1_err_info_usign16_5,
            trans1_err_info_usign16_6,
            trans1_err_info_usign16_7,
            trans1_err_info_usign16_8,
            trans1_err_info_usign16_9,
            trans1_err_info_usign16_10
        }
    }
}

COMMAND read_trans1_err_info_usign8
{
    BLOCK transducer_block_1;
    INDEX 91;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_err_info_usign8_1,
            trans1_err_info_usign8_2,
            trans1_err_info_usign8_3,
            trans1_err_info_usign8_4,
            trans1_err_info_usign8_5,
            trans1_err_info_usign8_6,
            trans1_err_info_usign8_7,
            trans1_err_info_usign8_8,
            trans1_err_info_usign8_9,
            trans1_err_info_usign8_10
        }
    }
}

COMMAND read_trans1_err_info_octet
{
    BLOCK transducer_block_1;
    INDEX 92;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans1_err_info_octet_1,
            trans1_err_info_octet_2
        }
    }
}

/***********************************************************************/
/*    Menu                                                             */
/***********************************************************************/
MENU Page_diagnosis_trans1_modbus
{
    LABEL        "User Transducer";
    ITEMS
    {
        trans1_blk_object,
        trans1_blk_parent_class,
        trans1_blk_class,
        trans1_blk_dd_reference,
        trans1_blk_dd_rev,
        trans1_blk_profile,
        trans1_blk_profile_rev,
        trans1_st_rev,
        trans1_actual_mode,
        trans1_simulation_enabled (READ_ONLY)
    }
}

MENU Menu_s_config_modbus
{
    LABEL  "User Configuration";
    ITEMS
    {
        OnlineDialog_s_error_lookup,
        OnlineDialog_s_analog_input,
        OnlineDialog_s_analog_output,
        OnlineDialog_s_discrete_input,
        OnlineDialog_s_discrete_output,
        OnlineDialog_s_generic_float,
        OnlineDialog_s_generic_usign32,
        OnlineDialog_s_generic_usign16,
        OnlineDialog_s_generic_usign8,
        OnlineDialog_s_generic_Octet
    }
}

MENU OnlineDialog_s_error_lookup
{
    LABEL    "User Error Lookup";
    ITEMS
    {
        trans1_bad_status,
        trans1_err_look_result_in1,
        trans1_err_look_result_in2,
        trans1_err_look_result_in3,
        trans1_err_look_result_in4,
        trans1_err_look_result_out1,
        trans1_err_look_result_out2,
        trans1_err_look_result_out3,
        trans1_err_look_result_out4,
        trans1_err_look_result_in_d1,
        trans1_err_look_result_in_d2,
        trans1_err_look_result_in_d3,
        trans1_err_look_result_in_d4,
        trans1_err_look_result_out_d1,
        trans1_err_look_result_out_d2,
        trans1_err_look_result_out_d3,
        trans1_err_look_result_out_d4
    }
}

MENU OnlineDialog_s_analog_input
{
    LABEL    "User Analog Input";
    ITEMS
    {
        Page_s_modbus_mod_in1,
        Page_s_modbus_mod_in2,
        Page_s_modbus_mod_in3,
        Page_s_modbus_mod_in4
    }
}

MENU OnlineDialog_s_analog_output
{
    LABEL    "User Analog Output";
    ITEMS
    {
        Page_s_modbus_mod_out1,
        Page_s_modbus_mod_out2,
        Page_s_modbus_mod_out3,
        Page_s_modbus_mod_out4
    }
}

MENU OnlineDialog_s_discrete_input
{
    LABEL    "User Discrete Input";
    ITEMS
    {
        Page_s_modbus_mod_in_d1,
        Page_s_modbus_mod_in_d2,
        Page_s_modbus_mod_in_d3,
        Page_s_modbus_mod_in_d4
    }
}

MENU OnlineDialog_s_discrete_output
{
    LABEL    "User Discrete Output";
    ITEMS
    {
        Page_s_modbus_mod_out_d1,
        Page_s_modbus_mod_out_d2,
        Page_s_modbus_mod_out_d3,
        Page_s_modbus_mod_out_d4
    }
}

MENU OnlineDialog_s_generic_float
{
    LABEL    "User Generic Float";
    ITEMS
    {
        Page_s_generic_float
    }
}

MENU OnlineDialog_s_generic_usign32
{
    LABEL    "User Generic Usign32";
    ITEMS
    {
        Page_s_generic_usign32
    }
}

MENU OnlineDialog_s_generic_usign16
{
    LABEL    "User Generic Usign16";
    ITEMS
    {
        Page_s_generic_usign16
    }
}

MENU OnlineDialog_s_generic_usign8
{
    LABEL    "User Generic Usign8";
    ITEMS
    {
        Page_s_generic_usign8
    }
}

MENU OnlineDialog_s_generic_Octet
{
    LABEL    "User Generic Octet";
    ITEMS
    {
        Page_s_generic_Octet
    }
}

MENU Group_trans1_error_lookup_in1
{
    LABEL    "Error Lookup";
    ITEMS
    {
        trans1_err_look_result_in1
   }
}

MENU Group_trans1_error_lookup_in2
{
    LABEL    "Error Lookup";
    ITEMS
    {
        trans1_err_look_result_in2
   }
}

MENU Group_trans1_error_lookup_in3
{
    LABEL    "Error Lookup";
    ITEMS
    {
        trans1_err_look_result_in3
   }
}

MENU Group_trans1_error_lookup_in4
{
    LABEL    "Error Lookup";
    ITEMS
    {
        trans1_err_look_result_in4
   }
}

MENU Group_trans1_error_lookup_out1
{
    LABEL    "Error Lookup";
    ITEMS
    {
        trans1_err_look_result_out1
   }
}

MENU Group_trans1_error_lookup_out2
{
    LABEL    "Error Lookup";
    ITEMS
    {
        trans1_err_look_result_out2
   }
}

MENU Group_trans1_error_lookup_out3
{
    LABEL    "Error Lookup";
    ITEMS
    {
        trans1_err_look_result_out3
   }
}

MENU Group_trans1_error_lookup_out4
{
    LABEL    "Error Lookup";
    ITEMS
    {
        trans1_err_look_result_out4
   }
}

MENU Group_trans1_error_lookup_in_d1
{
    LABEL    "Error Lookup";
    ITEMS
    {
        trans1_err_look_result_in_d1
   }
}

MENU Group_trans1_error_lookup_in_d2
{
    LABEL    "Error Lookup";
    ITEMS
    {
        trans1_err_look_result_in_d2
   }
}

MENU Group_trans1_error_lookup_in_d3
{
    LABEL    "Error Lookup";
    ITEMS
    {
        trans1_err_look_result_in_d3
   }
}

MENU Group_trans1_error_lookup_in_d4
{
    LABEL    "Error Lookup";
    ITEMS
    {
        trans1_err_look_result_in_d4
   }
}

MENU Group_trans1_error_lookup_out_d1
{
    LABEL    "Error Lookup";
    ITEMS
    {
        trans1_err_look_result_out_d1
   }
}

MENU Group_trans1_error_lookup_out_d2
{
    LABEL    "Error Lookup";
    ITEMS
    {
        trans1_err_look_result_out_d2
   }
}

MENU Group_trans1_error_lookup_out_d3
{
    LABEL    "Error Lookup";
    ITEMS
    {
        trans1_err_look_result_out_d3
   }
}

MENU Group_trans1_error_lookup_out_d4
{
    LABEL    "Error Lookup";
    ITEMS
    {
        trans1_err_look_result_out_d4
   }
}

MENU Group_trans1_mod_in1
{
    LABEL    "Analog Input 1";
    ITEMS
    {
        trans1_mod_in1_value,
        trans1_mod_in1_status_quality,
        trans1_mod_in1_status_limit
   }
}

MENU Group_trans1_mod_in2
{
    LABEL    "Analog Input 2";
    ITEMS
    {
        trans1_mod_in2_value,
        trans1_mod_in2_status_quality,
        trans1_mod_in2_status_limit
   }
}

MENU Group_trans1_mod_in3
{
    LABEL    "Analog Input 3";
    ITEMS
    {
        trans1_mod_in3_value,
        trans1_mod_in3_status_quality,
        trans1_mod_in3_status_limit
   }
}

MENU Group_trans1_mod_in4
{
    LABEL    "Analog Input 4";
    ITEMS
    {
        trans1_mod_in4_value,
        trans1_mod_in4_status_quality,
        trans1_mod_in4_status_limit
   }
}

MENU Group_trans1_mod_out1
{
    LABEL    "Analog Output 1";
    ITEMS
    {
        trans1_mod_out1_value,
        trans1_mod_out1_status_quality,
        trans1_mod_out1_status_limit
   }
}

MENU Group_trans1_mod_out2
{
    LABEL    "Analog Output 2";
    ITEMS
    {
        trans1_mod_out2_value,
        trans1_mod_out2_status_quality,
        trans1_mod_out2_status_limit
   }
}

MENU Group_trans1_mod_out3
{
    LABEL    "Analog Output 3";
    ITEMS
    {
        trans1_mod_out3_value,
        trans1_mod_out3_status_quality,
        trans1_mod_out3_status_limit
   }
}

MENU Group_trans1_mod_out4
{
    LABEL    "Analog Output 4";
    ITEMS
    {
        trans1_mod_out4_value,
        trans1_mod_out4_status_quality,
        trans1_mod_out4_status_limit
   }
}

MENU Group_trans1_mod_in_d1
{
    LABEL    "Discrete Input 1";
    ITEMS
    {
        trans1_mod_in_d1_value,
        trans1_mod_in_d1_status_quality,
        trans1_mod_in_d1_status_limit
   }
}

MENU Group_trans1_mod_in_d2
{
    LABEL    "Discrete Input 2";
    ITEMS
    {
        trans1_mod_in_d2_value,
        trans1_mod_in_d2_status_quality,
        trans1_mod_in_d2_status_limit
   }
}

MENU Group_trans1_mod_in_d3
{
    LABEL    "Discrete Input 3";
    ITEMS
    {
        trans1_mod_in_d3_value,
        trans1_mod_in_d3_status_quality,
        trans1_mod_in_d3_status_limit
   }
}

MENU Group_trans1_mod_in_d4
{
    LABEL    "Discrete Input 4";
    ITEMS
    {
        trans1_mod_in_d4_value,
        trans1_mod_in_d4_status_quality,
        trans1_mod_in_d4_status_limit
   }
}

MENU Group_trans1_mod_out_d1
{
    LABEL    "Discrete Output 1";
    ITEMS
    {
        trans1_mod_out_d1_value,
        trans1_mod_out_d1_status_quality,
        trans1_mod_out_d1_status_limit
   }
}

MENU Group_trans1_mod_out_d2
{
    LABEL    "Discrete Output 2";
    ITEMS
    {
        trans1_mod_out_d2_value,
        trans1_mod_out_d2_status_quality,
        trans1_mod_out_d2_status_limit
   }
}

MENU Group_trans1_mod_out_d3
{
    LABEL    "Discrete Output 3";
    ITEMS
    {
        trans1_mod_out_d3_value,
        trans1_mod_out_d3_status_quality,
        trans1_mod_out_d3_status_limit
   }
}

MENU Group_trans1_mod_out_d4
{
    LABEL    "Discrete Output 4";
    ITEMS
    {
        trans1_mod_out_d4_value,
        trans1_mod_out_d4_status_quality,
        trans1_mod_out_d4_status_limit
   }
}

MENU Page_s_modbus_mod_in1
{
    LABEL    "Modbus Mod In 1";
    ITEMS
    {
        Group_trans1_mod_in1,
        Group_trans1_error_lookup_in1
   }
}

MENU Page_s_modbus_mod_in2
{
    LABEL    "Modbus Mod In 2";
    ITEMS
    {
        Group_trans1_mod_in2,
        Group_trans1_error_lookup_in2
   }
}

MENU Page_s_modbus_mod_in3
{
    LABEL    "Modbus Mod In 3";
    ITEMS
    {
        Group_trans1_mod_in3,
        Group_trans1_error_lookup_in3
   }
}

MENU Page_s_modbus_mod_in4
{
    LABEL    "Modbus Mod In 4";
    ITEMS
    {
        Group_trans1_mod_in4,
        Group_trans1_error_lookup_in4
   }
}

MENU Page_s_modbus_mod_out1
{
    LABEL    "Modbus Mod Out 1";
    ITEMS
    {
        Group_trans1_mod_out1,
        Group_trans1_error_lookup_out1
   }
}

MENU Page_s_modbus_mod_out2
{
    LABEL    "Modbus Mod Out 2";
    ITEMS
    {
        Group_trans1_mod_out2,
        Group_trans1_error_lookup_out2
   }
}

MENU Page_s_modbus_mod_out3
{
    LABEL    "Modbus Mod Out 3";
    ITEMS
    {
        Group_trans1_mod_out3,
        Group_trans1_error_lookup_out3
   }
}

MENU Page_s_modbus_mod_out4
{
    LABEL    "Modbus Mod Out 4";
    ITEMS
    {
        Group_trans1_mod_out4,
        Group_trans1_error_lookup_out4
   }
}

MENU Page_s_modbus_mod_in_d1
{
    LABEL    "Modbus Mod In_D 1";
    ITEMS
    {
        Group_trans1_mod_in_d1,
        Group_trans1_error_lookup_in_d1
   }
}

MENU Page_s_modbus_mod_in_d2
{
    LABEL    "Modbus Mod In_D 2";
    ITEMS
    {
        Group_trans1_mod_in_d2,
        Group_trans1_error_lookup_in_d2
   }
}

MENU Page_s_modbus_mod_in_d3
{
    LABEL    "Modbus Mod In_D 3";
    ITEMS
    {
        Group_trans1_mod_in_d3,
        Group_trans1_error_lookup_in_d3
   }
}

MENU Page_s_modbus_mod_in_d4
{
    LABEL    "Modbus Mod In_D 4";
    ITEMS
    {
        Group_trans1_mod_in_d4,
        Group_trans1_error_lookup_in_d4
   }
}

MENU Page_s_modbus_mod_out_d1
{
    LABEL    "Modbus Mod Out_D 1";
    ITEMS
    {
        Group_trans1_mod_out_d1,
        Group_trans1_error_lookup_out_d1
   }
}

MENU Page_s_modbus_mod_out_d2
{
    LABEL    "Modbus Mod Out_D 2";
    ITEMS
    {
        Group_trans1_mod_out_d2,
        Group_trans1_error_lookup_out_d2
   }
}

MENU Page_s_modbus_mod_out_d3
{
    LABEL    "Modbus Mod Out_D 3";
    ITEMS
    {
        Group_trans1_mod_out_d3,
        Group_trans1_error_lookup_out_d3
   }
}

MENU Page_s_modbus_mod_out_d4
{
    LABEL    "Modbus Mod Out_D 4";
    ITEMS
    {
        Group_trans1_mod_out_d4,
        Group_trans1_error_lookup_out_d4
   }
}

MENU Page_s_generic_float
{
    LABEL    "User Generic Float";
    ITEMS
    {
        trans1_generic_float_1,
        trans1_generic_float_2,
        trans1_generic_float_3,
        trans1_generic_float_4,
        trans1_generic_float_5,
        trans1_generic_float_6,
        trans1_generic_float_7,
        trans1_generic_float_8,
        trans1_generic_float_9,
        trans1_generic_float_10,
        COLUMNBREAK,
        trans1_err_info_float_1,
        trans1_err_info_float_2,
        trans1_err_info_float_3,
        trans1_err_info_float_4,
        trans1_err_info_float_5,
        trans1_err_info_float_6,
        trans1_err_info_float_7,
        trans1_err_info_float_8,
        trans1_err_info_float_9,
        trans1_err_info_float_10
    }
}

MENU Page_s_generic_usign32
{
    LABEL    "User Generic Usign32";
    ITEMS
    {
        trans1_generic_usign32_1,
        trans1_generic_usign32_2,
        trans1_generic_usign32_3,
        trans1_generic_usign32_4,
        trans1_generic_usign32_5,
        trans1_generic_usign32_6,
        trans1_generic_usign32_7,
        trans1_generic_usign32_8,
        trans1_generic_usign32_9,
        trans1_generic_usign32_10,
        COLUMNBREAK,
        trans1_err_info_usign32_1,
        trans1_err_info_usign32_2,
        trans1_err_info_usign32_3,
        trans1_err_info_usign32_4,
        trans1_err_info_usign32_5,
        trans1_err_info_usign32_6,
        trans1_err_info_usign32_7,
        trans1_err_info_usign32_8,
        trans1_err_info_usign32_9,
        trans1_err_info_usign32_10
    }
}

MENU Page_s_generic_usign16
{
    LABEL    "User Generic Usign16";
    ITEMS
    {
        trans1_generic_usign16_1,
        trans1_generic_usign16_2,
        trans1_generic_usign16_3,
        trans1_generic_usign16_4,
        trans1_generic_usign16_5,
        trans1_generic_usign16_6,
        trans1_generic_usign16_7,
        trans1_generic_usign16_8,
        trans1_generic_usign16_9,
        trans1_generic_usign16_10,
        COLUMNBREAK,
        trans1_err_info_usign16_1,
        trans1_err_info_usign16_2,
        trans1_err_info_usign16_3,
        trans1_err_info_usign16_4,
        trans1_err_info_usign16_5,
        trans1_err_info_usign16_6,
        trans1_err_info_usign16_7,
        trans1_err_info_usign16_8,
        trans1_err_info_usign16_9,
        trans1_err_info_usign16_10
    }
}

MENU Page_s_generic_usign8
{
    LABEL    "User Generic Usign8";
    ITEMS
    {
        trans1_generic_usign8_1,
        trans1_generic_usign8_2,
        trans1_generic_usign8_3,
        trans1_generic_usign8_4,
        trans1_generic_usign8_5,
        trans1_generic_usign8_6,
        trans1_generic_usign8_7,
        trans1_generic_usign8_8,
        trans1_generic_usign8_9,
        trans1_generic_usign8_10,
        COLUMNBREAK,
        trans1_err_info_usign8_1,
        trans1_err_info_usign8_2,
        trans1_err_info_usign8_3,
        trans1_err_info_usign8_4,
        trans1_err_info_usign8_5,
        trans1_err_info_usign8_6,
        trans1_err_info_usign8_7,
        trans1_err_info_usign8_8,
        trans1_err_info_usign8_9,
        trans1_err_info_usign8_10
    }
}

MENU Page_s_generic_Octet
{
    LABEL    "User Generic Octet";
    ITEMS
    {
        trans1_generic_Octet_1,
        trans1_generic_Octet_2,
        COLUMNBREAK,
        trans1_err_info_octet_1,
        trans1_err_info_octet_2
    }
}

MENU Tab_s_user_trd
{
    LABEL        "User Transducer";
    ITEMS
    {
        trans1_st_rev,
        trans1_generic_float_1,
        trans1_generic_float_2,
        trans1_generic_float_3,
        trans1_generic_float_4,
        trans1_generic_float_5,
        trans1_generic_float_6,
        trans1_generic_float_7,
        trans1_generic_float_8,
        trans1_generic_float_9,
        trans1_generic_float_10,
        trans1_generic_usign32_1,
        trans1_generic_usign32_2,
        trans1_generic_usign32_3,
        trans1_generic_usign32_4,
        trans1_generic_usign32_5,
        trans1_generic_usign32_6,
        trans1_generic_usign32_7,
        trans1_generic_usign32_8,
        trans1_generic_usign32_9,
        trans1_generic_usign32_10,
        trans1_generic_usign16_1,
        trans1_generic_usign16_2,
        trans1_generic_usign16_3,
        trans1_generic_usign16_4,
        trans1_generic_usign16_5,
        trans1_generic_usign16_6,
        trans1_generic_usign16_7,
        trans1_generic_usign16_8,
        trans1_generic_usign16_9,
        trans1_generic_usign16_10,
        trans1_generic_usign8_1,
        trans1_generic_usign8_2,
        trans1_generic_usign8_3,
        trans1_generic_usign8_4,
        trans1_generic_usign8_5,
        trans1_generic_usign8_6,
        trans1_generic_usign8_7,
        trans1_generic_usign8_8,
        trans1_generic_usign8_9,
        trans1_generic_usign8_10,
        trans1_generic_Octet_1,
        trans1_generic_Octet_2
    }
}
